/*
 * Copyright (c) 1997 Robert Nordier
 * All rights reserved.
 *
 * $Id: fts.c,v 1.1 1997/01/20 22:57:20 rnordier Exp $
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR(S) ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR(S) BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <string.h>
#include <dospath.h>
#include "fts.h"

/* ARGSUSED */
FTS *
fts_open(char *const * path_argv, int options, void *unused)
{
    FTS *ftsp;

    if ((ftsp = malloc(sizeof(FTS))) == NULL)
	return NULL;
    memset(ftsp, 0, sizeof(FTS));
    ftsp->ent.fts_path = ftsp->path;
    ftsp->ent.fts_level = -1;
    ftsp->argv = path_argv;
    return ftsp;
}

int
fts_close(FTS * ftsp)
{
    free(ftsp);
    return 0;
}

FTSENT *
fts_read(FTS * ftsp)
{
    struct stat sb;
    FTSENT *f;
    int error, e;

    error = 0;
    e = -1;
    f = &ftsp->ent;
    if (f->fts_info != FTS_D || f->fts_set != FTS_SKIP) {
	if (f->fts_level > -1) {
	    if (f->fts_info == FTS_D || f->fts_level > 0) {
		if (f->fts_info == FTS_D) {
		    f->fts_name = catpath(f->fts_path, f->fts_name,
					  "*.*");
		    f->fts_level++;
		    e = (int) _dos_findfirst(f->fts_path, _A_SUBDIR,
					ftsp->ff + f->fts_level - 1);
		}
		while (!e && *ftsp->ff[f->fts_level - 1].name == '.' ||
		       e == -1)
		    e = (int) _dos_findnext(ftsp->ff + f->fts_level - 1);
		if (!e) {
		    strcpy(f->fts_name,
			   ftsp->ff[f->fts_level - 1].name);
		    _strlwr(f->fts_name);
		    f->fts_info = (u_short)(ftsp->ff[f->fts_level - 1].attrib 
					    & _A_SUBDIR ? FTS_D : FTS_F);
		} else {
		    f->fts_name = cutpath(f->fts_path, f->fts_name);
		    if (e == 18)
			e = -1;
		    else if (e == 2 || e == 3) {
			f->fts_info = FTS_ERR;
			f->fts_errno = errno;
		    } else
			error = -1;
		}
	    }
	    if (e) {
		f->fts_level--;
		if (f->fts_level == -1)
		    ftsp->argv++;
	    }
	}
	if (e <= 0 && f->fts_level == -1) {
	    if (*ftsp->argv) {
		f->fts_level++;
		f->fts_name = stripath(strcpy(f->fts_path, *ftsp->argv));
		if (stat(f->fts_path, &sb)) {
		    f->fts_info = FTS_NS;
		    f->fts_errno = errno;
		} else
		    f->fts_info = (u_short)(S_ISDIR(sb.st_mode) ? 
					    FTS_D : FTS_F);
	    } else
		errno = 0;
	    e = 0;
	}
    }
    if (e == -1)
	f->fts_info = FTS_DP;
    f->fts_set = 0;
    return f->fts_level > -1 && !error ? f : NULL;
}

/* ARGSUSED */
int
fts_set(FTS * ftsp, FTSENT * f, int options)
{
    f->fts_set = options;
    return 0;
}
