/*
 * Copyright (c) 1997 Robert Nordier
 * All rights reserved.
 *
 * $Id: cwild.c,v 1.1 1997/01/20 22:57:48 rnordier Exp $
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR(S) ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR(S) BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * NOTE: This code is highly compiler-specific and is based in part on
 * the file `wild.c' supplied with DOS versions of the Microsoft C
 * compiler.
 */

#ifdef FMODEBIN
#include <fcntl.h>
#endif
#include <stdlib.h>
#include <string.h>
#include "dospath.h"
#include "dosglob.h"

extern int __argc;
extern char **__argv;

static char progname[9];
char *__progname = progname;

struct anode {
    struct anode *an_next;
    char *an_arg;
};

static struct anode *arglist = NULL;
static struct anode **endptr = &arglist;
static struct anode **dirptr;

static void setname(char *path);
static int addarg(char *arg);

int
_cwild(void)
{
    char buf[1024];
    struct anode *an;
    char **av;
    int err, ac;

    err = 0;
#ifdef FMODEBIN
    _fmode = _O_BINARY;
#endif
    setname(*__argv);
    for (av = __argv; *av; av++) {
	_strlwr(strcpy(buf, *av + 1));
	if (!strchr(buf, '/'))
	    (void) fixslash(buf);
	dirptr = endptr;
	if (**av != '"') {
	    buf[128] = 0;
	    err = exparg(buf + 128, buf, addarg);
	}
	if (!err && endptr == dirptr)
	    err = addarg(buf);
    }
    if (!err) {
	for (ac = 0, an = arglist; an; ac++, an = an->an_next);
	if ((av = malloc(sizeof(char *) * (size_t) (ac + 1))) == NULL)
	    err = -1;
	else {
	    __argv = av;
	    __argc = ac;
	    for (ac = 0; ac < __argc; ac++) {
		__argv[ac] = arglist->an_arg;
		an = arglist->an_next;
		free(arglist);
		arglist = an;
	    }
	    __argv[ac] = NULL;
	}
    }
    return err ? -1 : 0;
}

static void
setname(char *path)
{
    char *name, *ext;
    size_t len;

    if ((name = strrchr(path, '\\')) != NULL &&
	(ext = strrchr(++name, '.')) != NULL &&
	(len = (size_t) (ext - name)) < sizeof(progname))
	_strlwr(strncpy(progname, name, len));
    else
	__progname = path;
}

static int
addarg(char *arg)
{
    struct anode **ap;
    struct anode *an;

    ap = dirptr;
    while (*ap && strcmp(arg, (*ap)->an_arg) > 0)
	ap = &(*ap)->an_next;
    an = *ap;
    if ((*ap = malloc(sizeof(struct anode))) == NULL ||
	(arg = _strdup(arg)) == NULL)
	return -1;
    (*ap)->an_arg = arg;
    (*ap)->an_next = an;
    if (!an)
	endptr = &(*ap)->an_next;
    return 0;
}
